
package djh.games.pavajong ;

import java.awt.*;

//
// This code is released into the public domain as of 3/31/96.
// d.j.hudek
//


///////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////
//			class MuffedItException
///////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////


//
// Exception used to indicate when a player muffs it, and conveys
//	the Graphic, y position and side where it occurred
//	

public class MuffedItException extends Exception 
{

    	/////////////////////////////////////////////////////////////////
    	// 			Class Data
    	/////////////////////////////////////////////////////////////////

    	private static final String myString = "Missed the Ball.";

    	/////////////////////////////////////////////////////////////////
    	// 			Instance Data
    	/////////////////////////////////////////////////////////////////

	private Graphics	theG;
	private int		yPos;
	private int		side;

    	/////////////////////////////////////////////////////////////////
    	// 			Constructors
    	/////////////////////////////////////////////////////////////////

	/**
	 * Instantiates a MuffedItException with default values
	 *	(Graphics null, y position 0, side "left")
	 */
    	public MuffedItException()
    	{
	    theG = null;
	    yPos = 0;
	    side = Playground.OOPS_LEFT;
    	}

	/*
	 * Instantiates a MuffedItException
	 *
	 * @param g - the Graphics in which they muffed it
	 * @param y - the y position where it occured
	 * @param sd - Playground.OOPS_LEFT or Playground.OOPS_Right
	 */
	public MuffedItException( Graphics g, int y, int sd )
	{
	    theG = g;
	    yPos = y;
	    side = sd;
	}


    	/////////////////////////////////////////////////////////////////
    	// 			Methods
    	/////////////////////////////////////////////////////////////////

	/**
	 * Set Graphics value
	 * @param g - Graphics to include in the exception
	 */
	public void setGraphics( Graphics g )
	{
	    theG = g;
	}

	/**
	 * Get Graphics value
	 */
	public Graphics getGraphics()
	{
	    return( theG );
	}

	/**
	 * Set Y position
	 * @param y - the y position where they muffed it
	 */
	public void setY( int y )
	{
	    yPos = y;
	}

	/**
	 * Get Y position where they muffed it
	 */
	public int getY()
	{
	    return( yPos );
	}

	/**
	 * Set Playground side where they muffed it
	 * @param sd - Playground.OOPS_LEFT or Playground.OOPS_RIGHT
	 *		(if neither, default of LEFT is used)
	 */
	public void setSide( int sd )
	{
	    if( sd != Playground.OOPS_RIGHT )
	    {
		side = Playground.OOPS_LEFT;
	    }
	    else
	    {
	 	side = sd;
	    }
	}

	/**
	 * Get Playground side where they muffed it
	 */
	public int getSide()
	{
	    return( side );
	}


	////////////////////  Overridden Methods ///////////////////

	/**
	 * Overridden getMessage()
	 * returns a String describing the exception
	 */
    	public String getMessage()
    	{
	    return( myString );
    	}

}

