
package djh.games.pavajong ;


//
// This code is released into the public domain as of 3/31/96.
// d.j.hudek
//


///////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////
//			class PaddleRegion
///////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////

public class PaddleRegion 
{

	/////////////////////////////////////////////////////////////////
	//			Class Data
	/////////////////////////////////////////////////////////////////

	protected static int TOP 	= 1;
	protected static int MIDDLE 	= 2;
	protected static int BOTTOM 	= 3;

	//
	// boundaries between top, middle, and bottom regions
	// of the paddle in terms of a ratio, counting the top 
	// as 0.0 and bottom as 1.0
	//
	//	0.0	top			
	//		TOP_TO_MIDDLE
	//		middle
	//		MIDDLE_TO_BOTTOM
	//	1.0	bottom
	//

	protected static final float TOP_TO_MIDDLE    = 0.3f;
	protected static final float MIDDLE_TO_BOTTOM = 0.7f;



	/////////////////////////////////////////////////////////////////
	//			Instance Variables
	/////////////////////////////////////////////////////////////////

	public int region;


	/////////////////////////////////////////////////////////////////
	//			Constructor
	/////////////////////////////////////////////////////////////////

	/**
	 * Instantiates a PaddleRegion
	 *	Sets the region to the default ("middle")
	 */
	PaddleRegion()
	{
	    region = MIDDLE;
	}

	/////////////////////////////////////////////////////////////////
	//			Methods
	/////////////////////////////////////////////////////////////////

	/**
	 * Given a range(low, high) and a current position, sets the
	 *	PaddleRegion region appropriately
	 *
	 * @param low - bottom of range
	 * @param hight - top of range
	 * @param current - current position for which the region
	 *	evaluation is desired
	 */
	void setRegion( int low, int high, int current )
	{
	    // top/middle/bottom a bit backwards compared
	    //	to low/high since origin is at top
	    //	and grows towards the bottom

	    int	fullRange = high - low;

	    if( (current - low) < (int)(TOP_TO_MIDDLE * fullRange) )
	    {
		region = TOP;
	    }
	    else if( (current - low) > (int)( MIDDLE_TO_BOTTOM * fullRange) )
	    {
		region = BOTTOM;
	    }
	    else
	    {
		region = MIDDLE;
	    }
	}


	/**
	 * returns true if current region indicates the top of the paddle
	 */
	public boolean isTop()
	{
	    return( region == TOP );
	}

	/**
	 * returns true if current region indicates the middle of the paddle
	 */
	public boolean isMiddle()
	{
	    return( region == MIDDLE );
	}

	/**
	 * returns true if current region indicates the bottom of the paddle
	 */
	public boolean isBottom()
	{
	    return( region == BOTTOM );
	}

}


