
package djh.games.pavajong ;


//
// This code is released into the public domain as of 3/31/96.
// d.j.hudek
//


///////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////
//			class HitTargetException
///////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////

public class HitTargetException extends Exception 
{
    	/////////////////////////////////////////////////////////////////
    	//			Class Data
    	/////////////////////////////////////////////////////////////////

    	private static final String myString = "Hit the Target.";

    	/////////////////////////////////////////////////////////////////
    	// 			Instance Variables
    	/////////////////////////////////////////////////////////////////

    	protected int value;


    	/////////////////////////////////////////////////////////////////
    	// 			Constructors
    	/////////////////////////////////////////////////////////////////

	/**
	 * Instantiate a HitTargetException
	 * This is used to indicate that a target was hit and
	 *	what is the value of the reward.
	 *
	 * The value will be set to default value (zero)
	 */
    	public HitTargetException()
    	{
	    value = 0;
    	}

	/**
	 * Instantiate a HitTargetException
	 *	with specified target value.
	 * This is used to indicate that a target was hit and
	 *	what is the value of the reward.
	 *
	 * @param v - value
	 */
    	public HitTargetException( int v )
    	{
	    value = v;
    	}


    	/////////////////////////////////////////////////////////////////
    	// 			Methods
    	/////////////////////////////////////////////////////////////////

	/**
	 * returns the value (target reward)
	 */
    	public int getValue()
    	{
	    return( value );
    	}

	/**
	 * set the value (target reward) to specified value
	 * @param v - desired value
	 */
    	public void setValue( int v )
    	{
	    value = v;
    	}

	/**
	 * add to the current value (target reward)
	 * @param v - amount to add
	 */
    	public void addValue( int v )
    	{
	    value += v;
    	}



	////////////////////// Overridden Methods //////////////////

	/**
	 * Overridden getMessage()
	 * returns a String describing the exception
	 */
    	public String getMessage()
    	{
	    return( myString + " Value=" + value );
    	}
}



