
package djh.games.pavajong ;

import java.awt.*;

//
// This code is released into the public domain as of 3/31/96.
// d.j.hudek
//


///////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////
//			class RainbowColors
///////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////

public class RainbowColors 
{

    	/////////////////////////////////////////////////////////////////
    	// 			Class Data
    	/////////////////////////////////////////////////////////////////

    	private static final int	State0 = 0; // initial state
    	private static final int	State1 = 1; // red increasing
	private static final int	State2 = 2; // green increasing
	private static final int	State3 = 3; // red decreasing
	private static final int	State4 = 4; // blue increasing
	private static final int	State5 = 5; // red increasing
	private static final int	State6 = 6; // all done

	private static final int	MAX_COLOR_VALUE = 255;
	private static final int	MIN_COLOR_VALUE = 0;

    	/////////////////////////////////////////////////////////////////
    	// 			Instance Data
    	/////////////////////////////////////////////////////////////////

	private int	red;
	private int	green;
	private int	blue;
	private int	state;
	private Color	theColor;

    	/////////////////////////////////////////////////////////////////
    	// 			Constructors
    	/////////////////////////////////////////////////////////////////

	/**
	 * Instantiates a RainbowColors object.
	 *
	 * This simple object offers a method that will return
	 *	different colors that run from black through
	 *	red through yellow through green through 
	 *	light blue to white, a method to indicate when
	 *	the sequence has ended, and a method to
	 *	reinit the sequence back to black.
	 */
    	public RainbowColors()
    	{
	    red 	= MIN_COLOR_VALUE;
	    green	= MIN_COLOR_VALUE;
	    blue 	= MIN_COLOR_VALUE;
	    state	= State0;
	    theColor 	= null;
    	}



    	/////////////////////////////////////////////////////////////////
    	// 			Methods
    	/////////////////////////////////////////////////////////////////

	/**
	 * Reinitialize 
	 */
	public void reinit()
	{
	    red 	= MIN_COLOR_VALUE;
	    green	= MIN_COLOR_VALUE;
	    blue 	= MIN_COLOR_VALUE;
	    state	= State0;
	    theColor 	= null;
	}

	/**
	 * returns true if sequence of colors has ended
	 */
	public boolean allDone()
	{
	    return( state == State6 );
	}

	/**
	 * Get next color
	 */
	public Color getNextColor()
	{
	    switch( state )
	    {
		case State0:
		    state = State1;
		    break;
		case State1:
		    // red increases up to MAX_COLOR_VALUE
		    if( ++red >= MAX_COLOR_VALUE )
		    {
			red   = MAX_COLOR_VALUE;
			state = State2;
		    }
		    break;
		case State2:
		    // green increases up to MAX_COLOR_VALUE
 		    if( ++green >= MAX_COLOR_VALUE )
		    {
			green = MAX_COLOR_VALUE;
			state = State3;
		    }
		    break;
		case State3:
		    // red decreases down to MIN_COLOR_VALUE
		    if( --red <= MIN_COLOR_VALUE )
		    {
			red   = MIN_COLOR_VALUE;
			state = State4;
		    }
		    break;
		case State4:
		    // blue increases up to MAX_COLOR_VALUE
		    if( ++blue > MAX_COLOR_VALUE )
		    {
			blue  = MAX_COLOR_VALUE;
			state = State5;
		    }
		    break;
		case State5:
		    // red increases up to MAX_COLOR_VALUE
		    if( ++red >= MAX_COLOR_VALUE )
		    {
			red   = MAX_COLOR_VALUE;
			state = State6;
		    }
		
		    break;
		default:
		    red   = green   = blue   = MAX_COLOR_VALUE;
		    state = State6;
		    break;
	    }
	    theColor = new Color( red, green, blue );
	    return( theColor );
	}


}

