
package djh.games.pavajong ;

import java.awt.*;


//
// This code is released into the public domain as of 3/31/96.
// d.j.hudek
//


///////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////
//			class Score
///////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////

public class Score extends Label
{
    	/////////////////////////////////////////////////////////////////
    	//			Class Data
    	/////////////////////////////////////////////////////////////////

    	protected static String TITLE = "SCORE";
    	protected static int	DEF_WIDTH  = 550;
    	protected static int 	DEF_HEIGHT = 50;


    	/////////////////////////////////////////////////////////////////
    	// 			Instance Variables
    	/////////////////////////////////////////////////////////////////

    	protected String	title;
    	protected int   	scoreValue;
	


   	/////////////////////////////////////////////////////////////////
    	// 			Constructor
    	/////////////////////////////////////////////////////////////////

	/**
	 * Extends Label. Displays current score.
	 */
    	public Score()
    	{
	    super( "", Label.CENTER );
	    title      = TITLE;
	    scoreValue = 0;
	    setFont( new Font( "Helvetica", Font.BOLD, 24 ) );

	    updateMyText();
    	}


    	/////////////////////////////////////////////////////////////////
    	// 			Methods
    	/////////////////////////////////////////////////////////////////

	/**
	 * resets score to zero
	 */
    	public void resetScore()
    	{
	    scoreValue = 0;
	    updateMyText();
    	}

	/**
	 * returns the current score
	 */
    	public int getScore()
    	{
	    return( scoreValue );
    	}

	/**
	 * sets the score to a particular value
	 * @param score - desired value for the score
	 */
    	public void setScore( int score )
    	{
	    scoreValue = score;
	    updateMyText();
    	}

	/**
	 * adds value to the current score
	 * @param increase - how much to add to the current score
	 */
    	public void addScore( int increase )
    	{
	    scoreValue += increase;
	    updateMyText();
    	}


	/**
 	 * updates the text string value of the Score label
	 *	to reflect the current score
	 */
    	public void updateMyText()
    	{
	    String text = TITLE + " : " 
			  + (new Integer(scoreValue).toString()) ;
	    setText(text); 
    	}


	/////////////////  Overridden Methods  ////////////////////

    	public Dimension minimumSize()
    	{
	    return( new Dimension(DEF_WIDTH,DEF_HEIGHT) );
    	}

    	public Dimension preferredSize()
    	{
	    return( minimumSize() );
    	}

}




